// ASN Filter Designer Professional v4.0.5
// Wed, 18 Oct 2017 09:50:05 GMT

// ** Primary Filter (H1)**

////Band#       Frequencies (Hz)     Att/Ripple (dB)
//    1         0.000,   25.000          0.001
//    2        64.104,  250.000         40.533
////
// Arithmetic = 'Floating Point (Single Precision)';
// Architecture = 'IIR';
// Structure = 'Direct Form II Transposed';
// Response = 'Lowpass';
// Method = 'User Defined';
// Biquad = 'Yes';
// Stable = 'Yes';
// Fs = 500.0000; //Hz
// Filter Order = 6;

// ** ASN Filter Designer Automatic Code Generator **
// ** Deployment to ARM CMSIS DSP Framework        **


//#define ARM_MATH_CM4   // Cortex-M4 (default)
#include "arm_math.h"
#include "cmsis_os2.h"                  // ::CMSIS:RTOS2


#define TEST_LENGTH_SAMPLES  512
#define BLOCKSIZE 32
#define NUMBLOCKS  (TEST_LENGTH_SAMPLES/BLOCKSIZE)

float32_t OutputValues[TEST_LENGTH_SAMPLES];
float32_t InputValues[TEST_LENGTH_SAMPLES];

float32_t *InputValuesf32_ptr = &InputValues[0];  // declare Input pointer 
float32_t *OutputValuesf32_ptr = &OutputValues[0]; // declare Output pointer

arm_biquad_cascade_df2T_instance_f32 S;

#define NUM_SECTIONS_IIR 3

// ** IIR Direct Form II Transposed Biquad Implementation **
// y[n] = b0 * x[n] + w1
// w1 = b1 * x[n] + a1 * y[n] + w2
// w2 = b2 * x[n] + a2 * y[n]

// IIR Coefficients
float32_t iirStatesf32[NUM_SECTIONS_IIR*5];
float32_t iirCoeffsf32[NUM_SECTIONS_IIR*5] = 
          {// b0, b1, b2, a1, a2
             0.1215975,  0.0751514,  0.1215975,  0.9095030, -0.2278495, 
             0.2081503, -0.1286440,  0.2081503,  1.2015820, -0.4892390, 
             0.7326008, -1.1853730,  0.7326008,  1.5383070, -0.8181361
          };



// Test loop code


volatile float32_t dbgout, dbgin;
					
// Test loop code

					
float32_t white_noise_gen(long *seed)
{
	float32_t rand;
	long A=2045;
	long C=5;
	long M=1048576;
	
	// Output(n+1)=(A*Output(n)+C) mod M
	// Ref: Real-time digital signal processing: implementations and applications, Kuo, Lee and Tian
	//
  *seed = (long) (A **seed + C) % M;
   rand = (float32_t) ((2 **seed / (float32_t)(M + 1)) - 1);
	
	return rand;
	}
					
					
	
void app_main (void *argument) {

  uint32_t n,k;

	long seed=12357;
	float32_t Amplitude = 0.21;
  // setup test sinusoid input
  for (n=0; n<TEST_LENGTH_SAMPLES; n++)
  	InputValues[n]= Amplitude + (arm_sin_f32(2*PI*50.00*n/500)/3)+white_noise_gen(&seed)/25; 

  // Initialise Biquads
  arm_biquad_cascade_df2T_init_f32 (&S, NUM_SECTIONS_IIR, &(iirCoeffsf32[0]), &(iirStatesf32[0]));

  // Perform IIR filtering operation
  for (k=0; k < NUMBLOCKS; k++)
  	arm_biquad_cascade_df2T_f32 (&S, InputValuesf32_ptr + (k*BLOCKSIZE), OutputValuesf32_ptr + (k*BLOCKSIZE), BLOCKSIZE);    // perform filtering 

  for (int i=0; i<TEST_LENGTH_SAMPLES; i++) {
		osDelay(1);
		dbgout = OutputValues[i];
		dbgin= InputValues[i];
	}
  for (;;) {}
}
 



